package jamezo97.clonecraft.item;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.dna.ItemData;

import java.util.List;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.CCEntityAnything;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

import org.lwjgl.input.Keyboard;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemNeedle extends Item{
	
	//0 = empty, 1 = blood, 2 = DNA

	public ItemNeedle(int par1) {
		super(par1);
		setHasSubtypes(true);
		setMaxStackSize(64);
		setTextureName("CloneCraft:needle");
	}
	
	public Icon blood, dna, serum;
	
	@Override
	public void registerIcons(IconRegister ir) {
		super.registerIcons(ir);
		blood = ir.registerIcon("CloneCraft:needleBlood");
		dna = ir.registerIcon("CloneCraft:needleDNA");
		serum = ir.registerIcon("CloneCraft:mutationSerum");
	}

	@Override
	public int getColorFromItemStack(ItemStack par1ItemStack, int par2) {
		int damage = par1ItemStack.getItemDamage();
		if(par2 != 0 && damage != 0){
			return new ItemData(par1ItemStack).getColour();
		}
		return 0xffffff;
	}
	
	
	
    /*@Override
	public boolean hasEffect(ItemStack par1ItemStack, int pass) {
		return new ItemData(par1ItemStack).isModified();
	}*/

	@Override
	public String getItemDisplayName(ItemStack stack) {
    	ItemData data = new ItemData(stack);
    	String type = null;
    	switch(stack.getItemDamage()){
    	case 1: type = "Blood"; break;
    	case 2: type = "DNA"; break;
    	case 3: return "Mutation Serum";
    	}
    	return data.getDisplayName("Needle", type, "", stack);
	}

	@SideOnly(Side.CLIENT)
    public boolean requiresMultipleRenderPasses(){
        return true;
    }

	@Override
	public Icon getIcon(ItemStack stack, int pass) {
		if(pass == 0){
			return itemIcon;
		}else{
			int damage = stack.getItemDamage();
			if(damage == 1){
				return blood;
			}else if(damage == 2){
				return dna;
			}else if(damage == 3){
				return serum;
			}else{
				return itemIcon;
			}
		}
	}
	
	@Override
	public ItemStack getContainerItemStack(ItemStack itemStack) {
		if(itemStack.getItemDamage() == 1){
			itemStack.setItemDamage(0);
			ItemData dna = new ItemData(itemStack);
			dna.drain();
			return itemStack;
		}
		return super.getContainerItemStack(itemStack);
	}
	
	@Override
	public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
		new ItemData(par1ItemStack).addInfo(par3List, Keyboard.isKeyDown(Keyboard.KEY_LSHIFT));
	}

	@Override
	public float getDamageVsEntity(Entity par1Entity, ItemStack itemStack) {
		return 2;
	}
	
	public void useOn(ItemStack stack, EntityLivingBase attacked, EntityPlayer player){
		if(stack.getItemDamage() == 0  && !(new ItemData(stack).isContaminated())){
			if((attacked.hurtResistantTime < 10 || attacked.hurtResistantTime == attacked.maxHurtResistantTime) && (attacked.isEntityAlive() || attacked.hurtResistantTime == attacked.maxHurtResistantTime)){
				player.worldObj.playSoundAtEntity(player, "random.drink", 0.5F, player.worldObj.rand.nextFloat() * 0.1F + 0.9F);
				boolean isCreative = player.capabilities.isCreativeMode;
				boolean canHurtEntity = ((attacked == player)?player.capabilities.disableDamage:(attacked.isEntityInvulnerable()));
				
				ItemStack singleItem = stack;
				if(stack.stackSize > 1){
					if(!isCreative){
						stack.stackSize--;
					}
					singleItem = stack.copy();
					singleItem.stackSize = 1;
				}
				
				if(attacked == player){
					if(!isCreative){
						attacked.attackEntityFrom(DamageSource.causePlayerDamage(player), 2.0f);
						addPotionEffects(attacked);
					}
				}else{
					addPotionEffects(attacked);
				}
				
				singleItem.setItemDamage(1);
				ItemData data = new ItemData(singleItem);
				if(attacked instanceof CCEntityAnything){
					data.setEntity(((CCEntityAnything)attacked).theEntity);
				}else{
					data.setEntity(attacked);
				}
				
				data.save();
				
				
				if(singleItem != stack){
					if(!player.inventory.addItemStackToInventory(singleItem)){
						player.dropPlayerItemWithRandomChoice(singleItem, false);
					}
				}
				
			}
		}else if(stack.getItemDamage() == 3){
			if(!player.worldObj.isRemote){
				EntityLivingBase mutate = attacked;
				ItemData data = new ItemData(stack);
				for(int a = 0; a < data.genes.length; a++){
					Gene gene = Gene.getGene(data.genes[a]);
					if(gene != null){
						mutate = gene.mutateLivingEntity(mutate, gene.getMaxAmount());
					}
				}
				if(!player.capabilities.isCreativeMode){
					data.drain();
					data.save();
					stack.setItemDamage(0);
				}
				
				player.worldObj.playSoundAtEntity(player, "random.drink", 0.5F, player.worldObj.rand.nextFloat() * 0.1F + 0.9F);
			}
			
		}
	}

	public ItemStack onItemRightClick(ItemStack stack, World par2World, EntityPlayer par3EntityPlayer) {
		useOn(stack, par3EntityPlayer, par3EntityPlayer);
		return stack;
	}



	@Override
    public boolean hitEntity(ItemStack stack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase){
		if(par3EntityLivingBase instanceof EntityPlayer){
			useOn(stack, par2EntityLivingBase, (EntityPlayer)par3EntityLivingBase);
		}
		return false;
    }

	
	/***
	 * Add the potion effects confusion(9), hunger(17) and weakness(18) to the given entity for 15 seconds (300/20).
	 * If the entity is a player who cannot be damaged, the effects wont be applied.
	 * @param e The entity to apply it to.
	 */
	public void addPotionEffects(EntityLivingBase e){
		if(!(e instanceof EntityPlayer && ((EntityPlayer)e).capabilities.disableDamage)){
			PotionEffect confusionEffect = e.getActivePotionEffect(Potion.confusion);
			int confusionTime = confusionEffect==null?300:300 + confusionEffect.duration;
			PotionEffect hungerEffect = e.getActivePotionEffect(Potion.hunger);
			int hungerTime = hungerEffect==null?300:300 + hungerEffect.duration;
			PotionEffect weaknessEffect = e.getActivePotionEffect(Potion.weakness);
			int weaknessTime = weaknessEffect==null?300:300 + weaknessEffect.duration;
			
			e.addPotionEffect(new PotionEffect(Potion.confusion.id, confusionTime, 0));
			e.addPotionEffect(new PotionEffect(Potion.hunger.id, hungerTime, 0));
			e.addPotionEffect(new PotionEffect(Potion.weakness.id, weaknessTime, 0));
			
			int averageTimes = (confusionTime + hungerTime + weaknessTime)/3;
			if(averageTimes > 1500){
				int poisonTime = (averageTimes - 1500)/2;
				e.addPotionEffect(new PotionEffect(Potion.poison.id, poisonTime, 0));
			}
		}
	}
	
	
    public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List){	
    	
    	ItemData data = new ItemData();
    	data.setEntity(CloneCraft.cloneId);
    	NBTTagCompound nbt = data.saveToNbt();
    	
    	par3List.add(new ItemStack(par1, 1, 0));
    	
    	ItemStack s2 = new ItemStack(par1, 1, 1);
    	s2.setTagCompound(nbt);
    	par3List.add(s2);
    	
    	ItemStack s3 = new ItemStack(par1, 1, 2);
    	s3.setTagCompound(nbt);
    	par3List.add(s3);
    }
	
	


}
